#pragma once
#include <SFML/Graphics.hpp>
#include <string>
#include <iostream>

#include "Input.h"
#include "MySprite.h"
#include "Mario.h"
#include "Enemy.h"
#include "Goomba.h"
#include "Koopa.h"
#include "Block.h"
#include "Coin.h"
#include "Pipe.h"
#include "Mushroom.h"
#include "Collision.h"
#include "Cursor.h"
#include "Timer.h"
#include "EnemyManager.h"
#include "ItemManager.h"
#include "MoveablesManager.h"
#include "AudioManager.h"
#include "GameMap.h"

//Level is our base types for all screens shown - Main Menu, How To Play, Main Game...

class Level {
public:

	Level(sf::RenderWindow* hwnd, Input* input);
	~Level();
	virtual void handleInput(float deltaTime);
	virtual void update(float deltaTime);
	virtual void render();

	enum LevelType {	//Create LevelType enum used for return pointer references to each level when we need to switch
		LevelType_HowToPlay,
		LevelType_MainMenu,
		LevelType_Lives,
		LevelType_MainGame,
		LevelType_GameOver,
		LevelType_TimeUp,
		LevelType_YouWin
	};

	static Level* QueryLevel(LevelType whichLevel);	//QueryLevel returns a pointer to our level instance when we need to switch levels
	static Level* currentLevel;	//Static pointer of type Level, currentLevel stores a pointer to the current Level we're on

	//	//	//	//
	static EnemyManager* enemyManager;
	static ItemManager* itemManager;
	static MoveablesManager* moveablesManager;				// Static pointers of our managers and map for this level instance
	static GameMap* gameMap;
	static AudioManager* audioManager;
	//	//	//	//

	sf::Texture marioTexture;
	Mario mario;	//Create Mario object for this level

	bool isPaused;	//Is the level paused or not

protected:
	sf::RenderWindow* window;
	Input* userInput;

	void beginDraw();
	void endDraw();

	std::string updateScoreText();	//updateScoreText changes scoreText to the string value of Mario's numerical score with correct formatting

	void setupTextObject(sf::Text* textObj);	//setupTextObject is used to set consistent fonts and font sizes between every text object
	sf::Font NESFont;	//Font object to store the font used in the game

	Cursor mouseCursor;	//Cursor object used to track and get mouse input

	sf::View levelView;	//levelView shows a portion of the level onto the screen - the area Mario is occupying which creates the sidescrolling effect

	sf::Text marioText;	//marioText is the "MARIO" string showed above the score at the top of the window
	sf::Text scoreText;	//scoreText is the text which displays Mario's score
	sf::Text coinsText;	//coinsText is the text which displays how many coins Mario has
	sf::Text worldText;	//worldText is the "WORLD" string showed in the top mid of the screen
	sf::Text levelText;	//levelText is the "1-1" string displaying the current level the player is on
	sf::Text timeText;	//timeText is the "TIME" string showed above the time itself
	sf::Text timeLeftText;	//timeLeftText is ths string showing the player how much time they have left to complete the level
	sf::Text pausedText;	//pausedText is the "GAME PAUSED" text which is displayed when the player pauses the game
	Coin coinBesideCount;	//coinBesideCount is the animated coin which displays beside coinsText. It makes sense to place this outside of ItemManager as this never EVER collides with anything

	sf::Texture backgroundTexture;	//The base background texture for the level without any GameItems/enemies spawned
	MySprite backgroundSprite;	//The sprite using backgroundTexture

	bool hasBackgroundStarted = false;	//Have we begun to play the background music?

};
